using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Xml;

namespace XML
{
    public partial class Form1 : Form
    {
        XmlDocument doc;

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            doc = new XmlDocument();
            doc.Load("employees.xml");
                   
            textBox1.Text = doc.OuterXml;
        }

        private void handle_xpath(String xPathExpression)
        {
            XmlNodeList result;
            XmlNode root = doc.DocumentElement;

            result = root.SelectNodes(xPathExpression);

            label1.Text = String.Format("{0} items returned", result.Count);
           
            textBox3.Clear();
            foreach (XmlNode x in result)
            {
                textBox3.Text = textBox3.Text + x.OuterXml + Environment.NewLine + Environment.NewLine;
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            handle_xpath(".//employee");
        }

        private void button3_Click(object sender, EventArgs e)
        {
            handle_xpath("/employees");
        }

        private void button4_Click(object sender, EventArgs e)
        {
            handle_xpath("/employees/employee[1]");
        }

        private void button5_Click(object sender, EventArgs e)
        {
            handle_xpath("/employees/employee[last()]");
        }

        private void button6_Click(object sender, EventArgs e)
        {
            handle_xpath("/employees/employee[emp_salary>30000 and emp_salary<35000]");
        }

        private void button7_Click(object sender, EventArgs e)
        {
            handle_xpath("/employees/employee[emp_salary>30000 and emp_salary<35000 and emp_salary[@currency='UKP']]");
        }

        private void button8_Click(object sender, EventArgs e)
        {
            handle_xpath("/employees/employee[emp_salary > 50000]/emp_lastname");
        }

        private void button9_Click(object sender, EventArgs e)
        {
            handle_xpath(textBox2.Text);
        }
    }
}